//-----------------------------------------------------------------------------
//
//  $Logfile:: /SiNMod/worldspawn.h                                           $
// $Revision:: 1                                                              $
//   $Author:: Connor Caple                                                   $
//     $Date:: 9/07/99 20:53                                                  $
//
// Copyright (C) 1997 by Ritual Entertainment, Inc.
// All rights reserved.
//
// This source is may not be distributed and/or modified without
// expressly written permission by Ritual Entertainment, Inc.
// 
/*
 * $Log: /SiNMod/worldspawn.h $
 * 
 * 1     9/07/99 20:53 Connor Caple
 * Initial import of modified files.
 */
// 2     9/26/97 6:14p Jimdose
// Added standard Ritual headers
//
// DESCRIPTION:
// Base class for worldspawn objects.  This should be subclassed whenever
// a DLL has new game behaviour that needs to be initialized before any other
// entities are created, or before any entity thinks each frame.  Also controls
// spawning of clients.
//

#ifndef __WORLDSPAWN_H__
#define __WORLDSPAWN_H__

#include "entity.h"

#ifdef EXPORT_TEMPLATE
template class EXPORT_FROM_DLL Container<Entity *>;
#endif

class EXPORT_FROM_DLL TargetList : public Class
	{
   public:
      CLASS_PROTOTYPE( TargetList );
      Container<Entity *>  list;
      str                  targetname;

		TargetList();
      TargetList( str &tname );
		~TargetList();
      void     AddEntity( Entity * ent );
      void     RemoveEntity( Entity * ent );
      Entity   *GetNextEntity( Entity * ent );
	};

#ifdef EXPORT_TEMPLATE
template class EXPORT_FROM_DLL Container<TargetList *>;
#endif

class EXPORT_FROM_DLL World : public Entity
	{
   private:
      Container<TargetList *> targetList;
	public:
      CLASS_PROTOTYPE( World );

		World();
		~World();

      str                     skipthread;

      void        FreeTargetList( void );
      TargetList  *GetTargetList( str &targetname );
      void        AddTargetEntity( str &targetname, Entity * ent );
      void        RemoveTargetEntity( str &targetname, Entity * ent );
      Entity      *GetNextEntity( str &targetname, Entity * ent );

      virtual void Archive( Archiver &arc );
      virtual void Unarchive( Archiver &arc );
	};

inline EXPORT_FROM_DLL void World::Archive
	(
	Archiver &arc
	)

	{
   Entity::Archive( arc );

   arc.WriteString( skipthread );
	}

inline EXPORT_FROM_DLL void World::Unarchive
	(
	Archiver &arc
	)

	{
   FreeTargetList();

   Entity::Unarchive( arc );

   skipthread = arc.ReadString();
	}

#ifdef EXPORT_TEMPLATE
template class EXPORT_FROM_DLL SafePtr<World>;
#endif

typedef SafePtr<World> WorldPtr;
extern WorldPtr world;

#endif /* worldspawn.h */
